/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import {
  j2s,
  Logger,
  succeedOrThrow,
  TalerExchangeHttpClient,
  TalerMerchantInstanceHttpClient,
} from "@gnu-taler/taler-util";
import { startFakeChallenger } from "../harness/fake-challenger.js";
import { GlobalTestState, harnessHttpLib } from "../harness/harness.js";
import {
  createTopsEnvironment,
  doTopsAcceptTos,
  doTopsKycAuth,
} from "../harness/tops.js";

export const logger = new Logger("test-tops-aml.ts");

export async function runTopsAmlLegiTest(t: GlobalTestState) {
  // Set up test environment
  const {
    exchange,
    officerAcc,
    merchant,
    exchangeBankAccount,
    wireGatewayApi,
    merchantAdminAccessToken,
    bank,
  } = await createTopsEnvironment(t);

  const challenger = await startFakeChallenger({
    port: 6001,
    addressType: "postal-ch",
  });

  const merchantClient = new TalerMerchantInstanceHttpClient(
    merchant.makeInstanceBaseUrl(),
  );
  const exchangeClient = new TalerExchangeHttpClient(exchange.baseUrl, {
    httpClient: harnessHttpLib,
  });

  // Do KYC auth transfer
  const { accessToken } = await doTopsKycAuth(t, {
    merchantClient,
    exchangeBankAccount,
    wireGatewayApi,
    merchantAdminAccessToken,
    bank,
  });

  // Accept ToS
  await doTopsAcceptTos(t, {
    accessToken,
    exchangeClient,
    merchantClient,
    merchant,
    merchantAdminAccessToken,
  });

  const legis = succeedOrThrow(
    await exchangeClient.getAmlLegitimizations(officerAcc),
  );

  console.log(j2s(legis));

  t.assertDeepEqual(
    legis.measures[0].measures.measures[0].prog_name,
    "check-tos",
  );
}

runTopsAmlLegiTest.suites = ["wallet"];
