/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_upsert_donau_keys.h
 * @brief implementation of the upsert_donau_keys function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#ifndef PG_UPSERT_DONAU_KEYS_H
#define PG_UPSERT_DONAU_KEYS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"
#include "donau/donau_service.h"

/**
 * Function to insert or update Donau keys in the merchant_donau_keys table.
 *
 * @param cls closure
 * @param keys the DONAU_Keys object
 * @param first_retry time when we make retry to update keys
 * @return GNUNET_DB_QueryStatus transaction status
 */
enum GNUNET_DB_QueryStatus
TMH_PG_upsert_donau_keys (void *cls,
                          const struct DONAU_Keys *keys,
                          struct GNUNET_TIME_Absolute first_retry);


#endif
